package gov.va.genisis2.common.enums;

public enum RoleTypeEnum {

	ADMIN(1, "Administrator"), 
	REQUESTER(2, "requester"),
	DDM(3, "dataDestinationManager"),
	DSM(4, "dataSourceManager");

	private int id;
	private String desc;

	/**
	 * @param id
	 * @param desc
	 */
	private RoleTypeEnum(int id, String desc) {
		this.id = id;
		this.desc = desc;
	}

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @return the desc
	 */
	public String getDesc() {
		return desc;
	}
	
	public static int getRoleTypeEnum(String roleName) {
		int roleId;
		if (null == roleName || roleName.isEmpty()) {
			return 0;
		}
		
		if (roleName.equalsIgnoreCase(RoleTypeEnum.ADMIN.name())) {
			roleId = RoleTypeEnum.ADMIN.getId();
		} else if (roleName.equalsIgnoreCase(RoleTypeEnum.DDM.name())) {
			roleId = RoleTypeEnum.DDM.getId();
		} else if (roleName.equalsIgnoreCase(RoleTypeEnum.DSM.name())) {
			roleId = RoleTypeEnum.DSM.getId();
		} else {
			roleId = RoleTypeEnum.REQUESTER.getId();
		}
		
		return roleId; 
	}
}
